import React from "react"
import { Modal } from "antd-mobile"
import "./index.scss"

export default function ({
  amount,
  limit_amount,
  onCancel = () => {},
  onConfirm,
}) {
  const content = (
    <>
      <div className="end-expansion-alert-ques">
        {`你的${amount}元优惠券正在膨胀中，
                确定要结束膨胀吗？`}
      </div>
      <div className="end-expansion-alert-hint">
        {`离${limit_amount}元只差一点点了！继续膨胀，优惠更多哦`}
      </div>
    </>
  )
  Modal.alert("温馨提示", content, [
    { text: "再考虑下", onPress: onCancel, style: { color: "#333" } },
    { text: "确定结束膨胀", onPress: onConfirm },
  ])
}
