import React, { Component } from 'react'
import './index.scss'
import { getParam, http, browser } from "@/utils";
import { Toast } from 'antd-mobile';
import { Link, withRouter } from "react-router-dom";
import { compose } from "redux";
import { connect } from "react-redux";
import { differenceInHours, differenceInMinutes, differenceInSeconds } from "date-fns";


class Single extends Component {
    constructor(props) {
        super(props)
        this.state = {
            // status: 1,
            orderId: '',
            nowPrice: '',
            laterPrice: '',
            hour: '',
            min: '',
            sec: '',
            endTime: '',
            groupOrderId: '',
            payType: '0',  // 1支付宝 0微信
            // singleBox: false,
        }
    }

    componentDidMount() {

    }

    componentWillReceiveProps(nextProps, nextContext) {
        // console.log(nextProps);
        // this.setState({
        //     singleBox: nextProps.singleBox
        // })
    }

    // 选择支付方式
    check = (type) => {
        this.setState({
            payType: type
        })
    }

    // 确定购买
    toBuy = () => {
        const videoID = this.props.data.video_id || this.props.data.id;
        http.get(`${API.home}/sys/createClassOrder/${videoID}`).then((res) => {
            if (res.data.code === 200) {
                this.setState({
                    orderId: res.data.data.order_id
                })
                this.state.payType === '1' ? this.alipayPay(res.data.data.order_id) : this.weixinPay(res.data.data.order_id)
            } else {
                Toast.info(res.data.msg, 2)
            }
        })
    }
    // 微信支付
    weixinPay = (orderId) => {
        // 微信内部-支付
        if (browser.isWeixin) {
            window.location.href = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=wx23dac6775ac82877&redirect_uri=" + encodeURIComponent(window.location.href + "&aa=bb&oid=" + orderId).toLowerCase() + "&response_type=code&scope=snsapi_userinfo&state=STATE#wechat_redirect";
        } else {
            // 微信外部-支付
            http.get(`${API['base-api']}/pay/wxpay/wap_charge/oid/${orderId}`).then((res) => {
                if (res.data.errno === 0) {
                    window.location.href = res.data.data.url + "&redirect_url=" + encodeURIComponent(window.location.href + "&weixinpay=1&oid=" + orderId).toLowerCase();
                } else {
                    Toast.info(res.data.msg, 2)
                }
            })
        }
    }
    // 支付宝支付
    alipayPay = (orderId) => {
        const courseId = getParam('id');
        http.get(`${API['base-api']}/pay/alipay/wap_charge_new/oid/${orderId}`).then((res) => {
            if (res.data.errno === 0) {
                window.location = res.data.data.url;
                courseId && window.localStorage.setItem('payCourse', courseId);
            } else {
                Toast.info(res.data.msg, 2)
            }
        })
    }

    // 特价购买全集
    toBuyAll = (vcourseId) => {
        if(Number(this.props.isPdd) === 1) {
            this.props.history.push(`/order?id=${this.props.courseId}`, {group: 1})
        }else{
            let cidArr = JSON.stringify([Number(vcourseId)]);
            http.get(`${API['base-api']}/m/cart/addtopreorder/${cidArr}`).then((res) => {
                if (res.data.errno === 0) {
                    this.props.history.push("/order?id=" + res.data.data[0], {simple: 1});
                } else {
                    Toast.info(res.data.msg, 2);
                }
            })
        }
    }
    // 0元购买全集
    zerobuyReceive = () => {
        Toast.success('购买全集成功', 3)
        this.colse()
    }
    // 0元参团
    zerogroupBuy = () => {
        this.getOrderId()
    }

    // 获取订单号-0元参团
    getOrderId = () => {
        let data = {
            course_id: getParam('id')
        }
        http.post(`${API['base-api']}/pdd/sys`, data).then((res) => {
            if (res.data.errno === 0) {
                this.setState({
                    groupOrderId: res.data.data.order_id
                })
                this.getOrderStatus(res.data.data.order_id)
            } else {
                Toast.info(res.data.msg, 2)
            }
        })
    }

    // 获取订单状态-0元参团
    getOrderStatus = (id) => {
        http.get(`${API.home}/m/pdd/order_status/${id}`).then((res) => {
            if (res.data.code === 200) {
                this.getTime(res.data.data.pdd_order_id)
            } else {
                Toast.info(res.data.msg, 2)
            }
        })
    }
    // 获取倒计时-0元参团
    getTime = (id) => {
        http.get(`${API.home}/m/pdd_order_end_time/${id}`).then((res) => {
            if (res.data.code === 200) {
                this.setState({
                    endTime: res.data.data.end_time,
                    status: 7
                })
            } else {
                Toast.info(res.data.msg, 2)
            }
        })
    }

    // 邀请好友参团
    toGroup = () => {
        this.props.history.push(`/togroup?id=${this.state.groupOrderId}`)
    }

    toLearn = (vcourseId, videoID) => {
        this.props.boxHide(false);
        this.props.history.push(`/play/video?id=${vcourseId}&video_id=${videoID}`);
    }


    // 关闭弹窗
    colse = () => {
        this.props.boxHide(false);
        this.setState({
            status: 1
        })
    }

    render() {
        let {singleBox} = this.state;
        if (this.state.endTime) {
            let date = this.state.endTime * 1000
            let now = Date.now()
            setInterval(() => {
                date -= 1000
                let s = differenceInSeconds(new Date(date), now) % 60,
                    m = differenceInMinutes(new Date(date), now) % 60,
                    h = differenceInHours(new Date(date), now) % 24
                this.setState({
                    hour: h,
                    min: m,
                    sec: s,
                })
            }, 1000)
        }
        const { singleType } = this.props;
        // console.log(this.props);
        const videoID = this.props.data.video_id || this.props.data.id;
        return (
          <div className='popup-box'>
          {
              singleType === 2 &&
              <div className='content payment-success'>
                  <div className="header">
                      <i className='iconfont icondanseshixintubiao-5'></i>
                      <span>购买成功</span>
                  </div>
                  <div className="dec">· 3天内购买全集，可直接抵扣该集费用，{this.props.nowPrice}元购买。</div>
                  <div className="dec">· 超过3天，按照未购集数/全部集数等比例计费，{this.props.laterPrice}元购买全集。</div>
                  <span onClick={()=>this.toLearn(this.props.vcourseId,videoID)} className='btn btn-18B4ED'>开始学习</span>
                  <div className='btn btn-FF4000' onClick={()=>{this.toBuyAll(this.props.courseId)}}>￥{this.props.nowPrice}购买全集
                  </div>
              </div>
          }
          {
              singleType === 3 &&
              <div className='content zero'>
                  <div className="header">
                      <i className='iconfont icondanseshixintubiao-5'></i>
                      <span>购买成功</span>
                  </div>
                  <div className="dec">· 恭喜您获得0元拼团购买剩余课时的机会。</div>
                  <div className='btn btn-FF4000' onClick={this.zerogroupBuy}>0元参团</div>
              </div>
          }
          {
              singleType === 4 &&
              <div className='content zero'>
                  <div className="header">
                      <i className='iconfont icondanseshixintubiao-5'></i>
                      <span>购买成功</span>
                  </div>
                  <div className="dec">· 恭喜您获得0元购买剩余课时的机会。</div>
                  <div className='btn btn-FF4000' onClick={this.zerobuyReceive}>0元购</div>
              </div>
          }
          {
              singleType === 6 &&
              <div className='content zero'>
                  <div className="header">
                      <i className='iconfont icondanseshixintubiao-5'></i>
                      <span>购买成功</span>
                  </div>
                  {/*<Link to={`/play/video?id=${this.props.vcourseId}&video_id=${videoID}`} className='btn btn-18B4ED'>去学习</Link>*/}
                  <span onClick={()=>this.toLearn(this.props.vcourseId,videoID)} className='btn btn-18B4ED'>去学习</span>
              </div>
          }
          {
              singleType === 7 &&
              <div className='content group'>
                  <div className="header">
                      <i className='iconfont icondanseshixintubiao-5'></i>
                      <span>参团成功</span>
                  </div>
                  <div className='group-img'>
                      <img src={this.props.user.data.avatar} alt=""/>
                      <img
                          src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/images/weekend/train7/ellipsis.png"
                          alt=""/>
                      <img
                          src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/images/weekend/train7/ellipsis.png"
                          alt=""/>

                  </div>
                  <div className='btn-l btn-FF4000' onClick={this.toGroup}>
                      剩余{String(this.state.hour).padStart(2, 0)}：{String(this.state.min).padStart(2, 0)}：{String(this.state.sec).padStart(2, 0)}
                      邀请好友参团
                  </div>
              </div>
          }
          <i onClick={this.colse} className={'iconfont iconiconfront-2 close'}></i>
      </div>

        );
    }

}

export default compose(
    connect(
        state => ({user: state.user}),
        null
    ),
    withRouter
)(Single)
