import React, { Component } from 'react'
import './index.scss'
import Description from './Description/index.js';
import NoWorry from './NoWorry/index.js';
import Study from './Study/index.js';
import Test from './Test/index.js';
import Team from './Team/index.js';
import Experience from './Experience/index.js'
import Progream from './Progream/index.js'
import Mask from './../poup/index.js'
import {http, getParam, SendMessageToApp, } from '@/utils'
import { connect } from 'react-redux';
import { Toast } from "antd-mobile";
@connect(state => ({
  user: state.user
}))
class PythonDes extends Component {
  constructor(props) {
    super(props);
    this.state = {
      syllabus: [], // 阶梯学习
      allSyllabus: [], // 阶梯学习
      allSyllabusShow: false,
      practice: [], // 课后实操
      allPractice: [], // 课后实操
      allPracticeShow: false,
      toApp: false,
      defineList: [
        {
          titleUrl: 'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/trophy.png',
          title: '排名第1的编程语言',
          subTitle: '2018世界编程语言排行榜中，Python排名第1',
          subWidth: '180px',
          bottomUrl: 'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/program_lan.png',
          desInfo: {
            width: '240px',
            height: '170px',
          }
        },
        {
          titleUrl: 'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/kaifa.png',
          title: '开发快速、简单易掌握',
          subTitle: '严谨的代码编写格式，语法格式简单易理解完成一个相同的任务',
          subWidth: '260px',
          bottomUrl: 'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/kuaisu.png',
          desInfo: {
            width: '212px',
            height: '106px',
          }
        },
        {
          titleUrl: 'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/lingyu.png',
          title: '适用领域广',
          subTitle: 'Python工程师可从事多领域编程工作，人才年需求增长6倍',
          subWidth: '230px',
          bottomUrl: 'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/jiandan.png',
          desInfo: {
            width: '234px',
            height: '106px',
          }
        }
      ],
      desList: [
        {url: 'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/xingshi.png', title: '全新课程形式', subTitle: '对话式交互教学，轻松、生动、不无聊'},
        {url: 'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/huanjing.png', title: '在线编程环境', subTitle: '无需安装任何编程软件'},
        {url: 'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/rumen.png', title: '20天零基础入门', subTitle: '降低学习门槛，20天入门人工智能'},
      ],
      worryList: [
        {url: 'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/jiechu.png', title: '初次接触，担心学不会', subTitle: '本课程专门为零基础的你打造，全篇通过最白话沟通交流的方式进行讲解，无论你有无编程经验都可以轻松理解并且掌握。'},
        {url: 'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/xuexi.png', title: '想学习，没有坚持下来', subTitle: '以故事性的方式编写学习内容， 把生硬的知识点有趣化。精美的图片+幽默的文字+代码编写让你越学越向学。'},
        {url: 'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/zhishidian.png', title: '知识点掌握了，不知如何运用', subTitle: '每节课的知识点都设有代码编写部分，每节课课后都有课后实操。有多次代码编写练习的机会，助你真正学以致用。'},
      ],
    }
  }

  // 立即报名
  signUp = () => {
    // 已登录
    if(!this.props.user.hasError) {
      this.toDetail();
    }else{// 未登录
      this.toLogin();
    }
  }

  // 立即体验、免费试学
  tryLearn = () => {
    // 已登录
    if(!this.props.user.hasError) {
      this.toLearn();
    }else{// 未登录
      this.toLogin();
    }
  }

  toLearn = () => {
    const id = getParam('id');
    if (!getParam('version')) { // H5
      this.setState({
        toApp: true
      })
    } else { // APP
      Toast.info('APP待定');
      // SendMessageToApp("toCourse", id); // TODO 待定 需要APP确认
    }
  }

  closePop = () => {
    this.setState({
      toApp: false
    })
  }

  toDetail = () => {
    const id = getParam('id');
    if (!getParam('version')) { // H5
      http.get(`${API['base-api']}/m/cart/addtopreorder/[${id}]`).then((res) => {
        if (res.data.errno === 0) {
            this.props.history.push(`/order?id=${id}`, {simple: 1})
        } else {
            Toast.info(res.data.msg, 2);
        }
      })
    } else { // APP
      SendMessageToApp('toPay', id);
    }
  }

  toLogin = () => {
    if (!getParam('version')) { // H5
      this.props.history.push('/passport');
    } else { // APP
      SendMessageToApp("toLogin");
    }
  }

  showAll = (key) => {
    if(key === 1) {
      this.setState({
        syllabus: this.state.allSyllabus,
        allSyllabusShow: true,
      })
    }
    if(key === 2) {
      this.setState({
        practice: this.state.allPractice,
        allPracticeShow: true,
      })
    }
  }
  hideSome = (key) => {
    if(key === 1) {
      this.setState({
        syllabus: this.state.allSyllabus.slice(0, 2),
        allSyllabusShow: false,
      })
    }
    if(key === 2) {
      this.setState({
        practice: this.state.allPractice.slice(0, 2),
        allPracticeShow: false,
      })
    }
  }

  componentDidMount() {
    http.get(`${API['home']}/web/it_detail?course_id=180`).then(res => {
      const { code, data, msg } = res.data
      if (code == 200) {
        this.setState({
          syllabus: data.syllabus.slice(0, 2),
          allSyllabus: data.syllabus,
          practice: data.practice.slice(0, 2),
          allPractice: data.practice,
        })
      } else {
        Message.warning(msg);
      }
    });
  }

  render() {
    const {defineList, desList, worryList, syllabus, practice, allSyllabusShow, allPracticeShow, toApp} = this.state;
    return (
      <div className={'python__des'}>
        <div className={'des__start'}></div>
        <div className={'python__define'}>
          <img className={'left__decorate'} src={'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/left__decorate.png'}></img>
          <img className={'right__decorate'} src={'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/right__decorate.png'}></img>
          <p className={'define__title'}>什 / 么 / 是 / Python</p>
          {
            defineList.map((item,index) => {
              return <DefineItem item={item} key={index}></DefineItem>
            })
          }
        </div>
        <div className={'course__introduce'}></div>
        <div className={'bottom__btn_group'}>
          <div className={'course__price'}>
            <div className={'money'}>199<span style={{fontSize: '18px'}}>元</span></div>
            <div className={'discount'}>
              限时特惠
              <div className={'triangle'}></div>
            </div>
          </div>

          <div className={'btn__group'}>
            <div className={'try__study'} onClick={this.tryLearn}>免费试学</div>
            <div className={'sign__now'} onClick={this.signUp}>立即报名</div>
          </div>
        </div>
        <Description list={desList}></Description>
        <NoWorry list={worryList}></NoWorry>
        <Study syllabus={syllabus} allSyllabusShow={allSyllabusShow} show={this.showAll} hide={this.hideSome}></Study>
        <Test practice={practice} allPracticeShow={allPracticeShow} show={this.showAll} hide={this.hideSome}></Test>
        <Team />
        <Experience tryLearn={this.tryLearn} />
        <img style={{display: 'block', width: '100%', height: '8px'}} src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/changjian.png" alt=""/>
        <Progream />
        {
          toApp && (<Mask type={1} closePop={this.closePop} />)
        }
      </div>
    )
  }
}

function DefineItem(props) {
  const {item, item: {desInfo}} = props;
  return (
    <div className={'number_one'}>
      <img className={'trophy'} src={item.titleUrl}></img>
      <p className={'item__title'}>{item.title}</p>
      <p className={'item__subtitle'} style={{width: item.subWidth}}>{item.subTitle}</p>
      <img style={{width: desInfo.width, height: desInfo.height}} src={item.bottomUrl}></img>
    </div>
  )
}

export default PythonDes
