import React, {PureComponent} from 'react';
import './index.scss'

import {http, getParam} from '@/utils'
import {WithFullSize} from '@/HOCs'
import {Toast} from 'antd-mobile'
import {HeaderBar} from "@/common";

class UsePatch extends PureComponent {
    constructor(props) {
        super(props);
        this.state = {
            success: false,
            checkedIndex: 0,
            list: [
                {
                    amount: 10,
                    desc: '兑换后7日内有效',
                    type: '代金券'
                },
                {
                    amount: 20,
                    desc: '兑换后7日内有效',
                    type: '代金券'
                },
                {
                    amount: 50,
                    desc: '兑换后7日内有效',
                    type: '代金券'
                },
                {
                    amount: 100,
                    desc: '兑换后7日内有效',
                    type: '代金券'
                }
            ],
            couponAmount: '',  // 碎片额度
        };
    }

    componentDidMount() {
        this.getPatchList()
    }

    // 选中
    select = (index, item) => {
        if (this.state.couponAmount >= item.amount) {
            this.setState({
                checkedIndex: index
            })
        }
    }

    // 合成
    compound = () => {
        const _this = this
        if (this.state.couponAmount >= 10) {
            http.post(`${API.home}/sys/red_packet/compose`, {type: _this.state.checkedIndex + 1}).then((res) => {
                if (res.data.code === 200) {
                    _this.setState({
                        success: true
                    })
                    setTimeout(() => {
                        _this.getPatchList()
                    }, 2000)

                } else {
                    Toast.info(res.data.msg, 2)
                }
            })
        }
    }

    getPatchList() {
        http.get(`${API.home}/sys/red_packet/balance`).then((res) => {
            if (res.data.code === 200) {
                this.setState({
                    couponAmount: res.data.data.coupon_amount,
                    success: false
                })
            } else {
                Toast.info(res.data.msg, 2)
            }
        })
    }

    render() {
        return (
            <div className='my-patch'>
                <div className={'couponAmount'}>
                    代金券碎片余额：<span>{this.state.couponAmount}元</span>
                </div>

                <Coupon data={this.state.list}
                        myAmount={this.state.couponAmount}
                        select={this.select}
                        checkedIndex={this.state.checkedIndex}/>
                <div className="compound-button--compose">
                <button
                    className={`compound ${this.state.couponAmount >= 10 ? 'disable-active' : 'disable'}`}
                    onClick={this.compound}>合成
                </button>
                </div>

                <div className="patch-desc">
                    <p className={'title'}><i></i><span>代金券碎片说明</span><i></i></p>
                    <p className={'desc-item'}>1. 碎片可通过“分享课程领取红包”获得，也可通过线上活动获得，具体请关注官网信息；</p>
                    <p className={'desc-item'}>2. 碎片在购课时不能单独使用，可合成完整代金券后用代金券抵扣现金；</p>
                    <p className={'desc-item'}>3. 碎片合成代金券后7日内有效。</p>
                </div>
                
                {
                    this.state.success &&
                    <div className="success">
                        兑换成功
                    </div>
                }
            </div>
        );
    }
}

function Coupon(props) {
    const {data, myAmount, select, checkedIndex} = props
    return (
        <div className={'coupons'}>
            {
                data && data.length > 0 && data.map((item, index) => {
                    return (
                        <div className='items-box' key={index} onClick={() => select(index, item)}>
                            <div className={`coupon-info ${myAmount >= item.amount ? 'active' : null}`}>
                                <div className="type">{item.type}</div>
                                <div className={'amount'}><span>{item.amount}</span>元</div>

                                {
                                    myAmount >= item.amount &&
                                    <i className={`checkout ${index === checkedIndex ? 'iconfont icondanseshixintubiao-5' : 'nochecked'}`}
                                    />
                                }
                                <ul>
                                    {
                                        new Array(19).fill('a').map((item, index) => {
                                            return <li key={index}/>
                                        })
                                    }
                                </ul>
                            </div>

                            <div className={'coupon-des'}>
                                {item.desc}
                            </div>
                        </div>
                    )
                })
            }
        </div>
    )
}


export default WithFullSize(UsePatch);