import React, { Component } from 'react'
import './index.scss'
import { getParam, http } from '@/utils'
import { WithFullSize } from "@/HOCs"

class PrizeWinnerList extends Component {

  state = {
    list: [],
    title: '',
  }

  componentDidMount() {
    http.get(`${API.home}/sys/activity/lottery_names/${getParam('tid')}`)
      .then(res => {
        const {data} = res
        if (data.code == 200) {
          const {data: response} = data
          this.setState({
            title: response.title,
            list: response.list
          })
        }
      })
  }

  render() {
    const {title, list} = this.state
    return (
      <div id={'prize-winner-list'}>
        <div className="banner">
          <img src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/active19_1111/m/prize-winner-list-banner.png" alt=""
               className="banner"/>
        </div>
        <h1>
          <img className={'icon'}
               src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/active19_1111/title-decorate-left.png" alt=""/>
          <span>{title}</span>
          <img className={'icon'}
               src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/active19_1111/title-decorate-right.png" alt=""/>
        </h1>
        <ul>
          <li className={'head title'}>
            <div className="code">中奖码</div>
            <div className="user-name">用户名称</div>
            <div className="prize">奖品名称</div>
          </li>
          {
            list.map(item => (
              <li key={item.code}>
                <div className="code">{item.code}</div>
                <div className="user-name">{item.name}</div>
                <div className="prize">{item.prize}</div>
              </li>
            ))
          }
        </ul>
      </div>
    )
  }
}

export default WithFullSize(PrizeWinnerList)
