import React, {Component} from 'react'
import {SearchBar} from 'antd-mobile'
import './index.scss'

class HeaderBar extends Component {
    toSearch() {
        window.location.href = '/search';
    }

    return() {
        window.location.href = '/';
    }

    goShop = () => {
        const { isLogin = false } = this.props;
        let url = isLogin? '/shopcart' : '/passport';
        window.location.replace(url);
    }

    render() {
        return (
            <div className='preferential'>
                <div className="search-nav">
                    {
                        !this.props.toHref &&
                        <i 
                            className={'iconfont iconiconfront-68 return'} 
                            onClick={this.return.bind(this)}
                        />
                    }
                    {
                        this.props.toHref &&
                        <i 
                            className={'iconfont iconiconfront-68 return'} 
                            onClick={this.props.toHref}
                        />
                    }
                    <SearchBar
                        placeholder="搜索课程"
                        cancelText={" "}
                        onFocus={this.toSearch.bind(this)}
                        showCancelButton={false}
                    />
                    <i 
                        className={'iconfont icongouwuche-xianxing shopping-cart'} 
                        onClick={this.goShop}
                    />
                </div>
            </div>
        )
    }

}

export default HeaderBar;
