import React, { Component } from "react"
import { Flex, WhiteSpace, WingBlank } from "antd-mobile"
import "./DrawDocument.scss"
import OpenApp from "src/common/CallApp"

export default class DrawDocument extends Component {
  render() {
    return (
      <div className={"drawDocument"}>
        <div>
          <WingBlank className={"navbar"}>
            <i
              className={"iconfont iconiconfront-68 back"}
              onClick={this.props.history.goBack}
            ></i>
            <div className={"common-ft-15"}>规则说明</div>
          </WingBlank>
        </div>

        <div className={"content"}>
          <WingBlank>
            <div className={"directions-div"}>分销规则</div>
            <WhiteSpace size="md"></WhiteSpace>
            <p className={"directions-p"}>
              点击『分享赚钱』生成您的专属海报，把专属海报分享到微信、微博、QQ、知乎、贴吧等，他人通过您的海报购买后您可获得相应的佣金奖励。
            </p>
            <WhiteSpace size="lg"></WhiteSpace>
            <WhiteSpace size="lg"></WhiteSpace>
            <div className={"directions-div"}>提现规则</div>
            <WhiteSpace size="md"></WhiteSpace>
            <p className={"directions-p"}>
              1. 已开始的直播课程，用户购买后佣金会实时转入您的账号余额；
            </p>
            <p className={"directions-p"}>
              2.
              尚未开课的直播课程，用户购买后归属您的佣金户暂时存放在『待确认金额』中，直到该课程正式开课。如果用户没有退款，对应的订单金额会自动转入您的账号余额，否则该佣金会自动收回；
            </p>
            <p className={"directions-p"}>3. 余额中的金额可随时提现。</p>
          </WingBlank>
        </div>

        <div className={"bottom"}>
          <WingBlank>
            <Flex justify="between" align="center" style={{ height: "44px" }}>
              <p className={"tip"}>收支明细及待确认金额请前往App查看</p>
              {/* <div className={'app'}>在APP打开</div> */}
              <OpenApp className="app" text="在APP打开" />
            </Flex>
          </WingBlank>
        </div>
      </div>
    )
  }
}
