import React, { Component } from "react"
import { InputItem, Button, WingBlank, Toast } from "antd-mobile"
import { withFormik } from "formik"
import { HeaderBar } from "../../common"
import { http } from "src/utils"

const InnerForm = ({ values, setFieldValue, handleSubmit }) => (
  <form>
    <InputItem
      clear
      name="real_name"
      onChange={(value) => setFieldValue("real_name", value)}
      placeholder="请输入您的真实姓名"
      value={values.real_name}
    >
      姓名
    </InputItem>
    <InputItem
      clear
      type="phone"
      name="cellphone"
      placeholder="请输入您的手机号码"
      onChange={(value) => setFieldValue("cellphone", value)}
      value={values.cellphone}
    >
      电话
    </InputItem>
    <InputItem
      clear
      name="qq"
      placeholder="请输入您的QQ号码"
      maxLength="15"
      onChange={(value) => setFieldValue("qq", value)}
      value={values.qq}
    >
      QQ
    </InputItem>

    <div style={{ marginTop: "21px" }}>
      <WingBlank>
        <Button type="primary" onClick={handleSubmit}>
          确认
        </Button>
      </WingBlank>
    </div>
  </form>
)

const MyForm = withFormik({
  mapPropsToValues: (props) => ({ ...props.userInfo }),
  validate: (values, props) => {
    const errors = {}
    return errors
  },
  handleSubmit: (values, FormBag) => {
    const { real_name, cellphone, qq } = values
    if (!real_name) {
      Toast.info("请输入姓名！", undefined, undefined, false)
      return
    } else if (`${real_name}`.replace(/\s+/g, "").length === 0) {
      Toast.info("请输入姓名！", undefined, undefined, false)
      return
    }
    if (!cellphone) {
      Toast.info("请输入手机号！", undefined, undefined, false)
      return
    } else if (!/1\d{10}/g.test(`${cellphone}`.replace(/\s+/g, ""))) {
      Toast.info("请输入正确的手机号！", undefined, undefined, false)
      return
    }
    if (!qq) {
      Toast.info("请输入QQ号！", undefined, undefined, false)
      return
    } else if (!/\d{5,}/g.test(qq)) {
      Toast.info("请输入正确QQ号！", undefined, undefined, false)
      return
    }
    let same = 0
    if (FormBag.props.userInfo) {
      const userInfo = FormBag.props.userInfo
      if (userInfo.real_name === real_name) {
        same += 1
      }
      if (userInfo.cellphone === cellphone) {
        same += 1
      }
      if (userInfo.qq === qq) {
        same += 1
      }
    }
    let pathName = "/order"
    if (FormBag.props.userInfo.id) {
      pathName = pathName + "?id=" + FormBag.props.userInfo.id
    }
    // console.log(values);
    if (same === 3) {
      FormBag.props.history.replace(pathName, {
        ...values,
      })
      return
    }
    http
      .post(`${API["base-api"]}/m/order/saveUserInfo`, {
        real_name: values.real_name,
        cellphone: `${values.cellphone}`.replace(/\s+/g, ""),
        qq: values.qq,
      })
      .then((res) => {
        // console.log(res);
        if (res.data.errno !== 200) {
          Toast.info(res.data.msg, undefined, undefined, false)
          return
        }
        Toast.info("保存成功！", undefined, undefined, false)
        FormBag.props.history.replace(pathName, {
          ...values,
        })
      })
  },
})(InnerForm)

class Orderinfo extends Component {
  render() {
    return (
      <div>
        <HeaderBar title="报名信息" arrow={true}></HeaderBar>
        <MyForm
          history={this.props.history}
          userInfo={this.props.location.state}
        />
      </div>
    )
  }
}

export default Orderinfo
