import React, { Component } from "react"
import { withRouter } from "react-router-dom"
import CommonContainer from "./../common/commonContainer/index"
import TreasureRank from "./rank"
import TeamInfo from "./team"
import Prizes from "src/components/activity/newyear-2019/common/prizes"
import UserBulletScreen from "src/components/activity/newyear-2019/common/user-bullet-screen"

class TreasureBox extends Component {
  render() {
    return (
      <CommonContainer id="year-treasure" title={"组队开宝箱"}>
        <div
          style={{
            textAlign: "center",
            fontSize: "12px",
            color: "#FFDC1E",
            marginTop: "10px",
          }}
        >
          邀请好友组队一起开宝箱，满5人后将随机获得以下奖品~
        </div>
        <Prizes showSystemNotices={true} />
        <UserBulletScreen />
        <TeamInfo
          isAppUpdate={this.props.isAppUpdate}
          getRemovable={this.props.getRemovable}
        />
        <TreasureRank history={this.props.history} />
      </CommonContainer>
    )
  }
}

export default withRouter(TreasureBox)
