import React, { Component } from "react"
import "./../index.scss"
import { http } from "src/utils"
import { Link } from "react-router-dom"
import { Toast } from "antd-mobile"
import icon1 from "../image/paperTranslate1.png"
import icon2 from "../image/paperReview2.png"
import icon3 from "../image/paperTranslate3.png"
import icon4 from "../image/2-2@2x.png"
class TeacherList extends Component {
  constructor(props) {
    super(props)
    this.state = {
      data: [],
      active: "",
      isToggleOn: false,
      liClass1: "",
    }
  }
  bgChange = (index) => {
    console.log(index, 999)
    this.setState({
      active: index,
    })
    this.setState((prevState) => ({
      isToggleOn: !prevState.isToggleOn,
      liClass1: prevState.isToggleOn ? "" : "active1",
    }))
  }

  componentDidMount() {
    http.get(`${API.home}/m/mobTeachers`).then((res) => {
      if (res.data.code === 200) {
        this.setState({
          data: res.data.data,
        })
      } else {
        Toast.info(res.data.msg, 2)
      }
    })
  }

  render() {
    const { active, liClass1, isToggleOn } = this.state
    return (
      <div className="paper">
        <p className="cont">论文审稿系统</p>
        <div className="teabox">
          <div className="paper-desc">
            我司通过对开源模型的优化，可对英文论文进行全面评审，评审效果超过GPT4
          </div>
          <div className="paper-box">
            <div>
              <img width={88} src={icon1} alt="" />
              <div>1.上传论文</div>
            </div>
            <div>
              <img width={88} src={icon2} alt="" />
              <div>2.论文解析</div>
            </div>
            <div>
              <img width={88} src={icon3} alt="" />
              <div>
                3.输出审稿
                <br />
                意见
              </div>
            </div>
          </div>
        </div>
        <div className="teabox">
          <div className="paper-desc">
            分析论文的优势、亮点，可能通过的原因、可能被拒绝的原因，提出针对性改进建议等
          </div>
          <div className="paper-box">
            <div>
              <img width={311} src={icon4} alt="" />
            </div>
          </div>
          <div className="consult1">
            <a>请前往PC端体验</a>
          </div>
        </div>
      </div>
    )
  }
}

export default TeacherList
