import React, { Component } from "react"
import "./index.scss"
import { http } from "src/utils"
import { Link } from "react-router-dom"
import { Toast } from "antd-mobile"

class ExpandActiveToast extends Component {
  constructor(props) {
    super(props)
    this.state = {
      expandLength: 0,
      isShowExpand: true,
    }
  }

  componentDidMount() {
    http.get(`${API["base-api"]}/sys/deposit/notice`).then((res) => {
      if (res.data.errno === 200) {
        const { data } = res.data
        this.setState({
          expandLength: data.num,
        })
      } else {
        Toast.info(res.data.msg, 2)
      }
    })
  }
  cleseExpand = () => {
    this.setState({ isShowExpand: false })
  }

  render() {
    return (
      <div>
        {this.state.expandLength > 0 && this.state.isShowExpand && (
          <div className="expand-active-toast">
            <img
              src="https://cdn.julyedu.com/active19_717/m/guanggao.png"
              alt=""
            />
            <div className="expand-toast-swiper">
              <p>
                您有<span className="red">{this.state.expandLength}个</span>
                待支付尾款的课程 再不支付就要过期了！
              </p>
            </div>
            <Link to="/final-deposit-order?source=1">查看</Link>

            <img
              onClick={(e) => this.cleseExpand()}
              src="https://cdn.julyedu.com/active19_717/m/guanbi.png"
              alt=""
            />
          </div>
        )}
      </div>
    )
  }
}

export default ExpandActiveToast
