import React from "react"
import { withKnobs, number, text } from "@storybook/addon-knobs"
import { action } from "@storybook/addon-actions"

import CourseCardH from "./course-card-h"
import CourseCardV from "./course-card-v"

export const courseData = {
  courseId: 140,
  title: "三月面试求职班",
  subtitle: "搞定算法  直通BAT",
  image: "https://img-public.julyedu.com/Public/Image/20a86c1353.jpg",
  marketing: "拼团减100元",
}

export default {
  title: "course-card",
  component: CourseCardH,
  decorators: [
    withKnobs,
    (story: () => React.ReactElement) => (
      <div className={"shadow"}>{story()}</div>
    ),
  ],
  excludeStories: /.*Data$/,
}

let { title, courseId, image, subtitle, marketing } = courseData
let navigate = action(`navigate to /detail?id=${courseId}`)

const status = <button className={"purchase"}>立即购买</button>

export const Default = () => {
  title = text("title", title)
  subtitle = text("subtitle", subtitle)
  image = text("image", image)
  courseId = number("courseId", courseId)
  marketing = text("marketing", marketing)

  return (
    <CourseCardH
      title={title}
      status={status}
      courseId={courseId}
      subtitle={subtitle}
      image={image}
      navigate={navigate}
      marketing={marketing}
    ></CourseCardH>
  )
}

export const V = () => {
  title = text("title", title)
  image = text("image", image)
  courseId = number("courseId", courseId)
  return (
    <CourseCardV
      image={image}
      courseId={courseId}
      status={status}
      title={title}
      navigate={navigate}
      marketing={marketing}
    ></CourseCardV>
  )
}
