import React, { PureComponent } from 'react';
import SearchHead from './searchHead'
import Tag from '@common/Tag/index.js'
import { http } from '@/utils'
import './index.scss';
import { Link } from 'react-router-dom'
import Loading from '@/common/Loading'


class Search extends PureComponent {

    state = {
        searchHistory: JSON.parse(localStorage.getItem('searchHistory')) || [],
        hot_words: [],
        defaultWord: '',
        searchList: [],
        value: '',
        isLoading: true
    }

    async componentDidMount() {
        const res = await http.get(`${API['search-api']}/search_hot_word`);
        const { errno, data } = res.data; 
        if (errno === 0) {
            this.setState({
                hot_words: data.info.hot_words,
                value: data.info.recommend_word,
                isLoading: false
            })
        }
    }

    clearHistory = () => {
        localStorage.setItem('searchHistory', null)
        this.setState({
            searchHistory: []
        })
    }

    handleChange = value => {
        this.setState({value})
    }

    handleSearch = () => {
        const { defaultWord, value } = this.state;
        const val = value || defaultWord;
        val && this.props.history.push(`/search-result?word=${encodeURIComponent(val)}`)
    }

    storeHistory = keyword => {
        const { searchHistory } = this.state;
        const data = searchHistory.some(item => item === keyword)? searchHistory : searchHistory.concat([keyword]);
        localStorage.setItem('searchHistory', JSON.stringify(data));
    }


    render() {
        const {searchHistory} = this.state
        return (
            <div className="search-page">
                <SearchHead
                    searchHistory={this.state.searchHistory}
                    value={this.state.value}
                    handleChange={this.handleChange}
                    handleSearch={this.handleSearch}
                />
                <Loading isLoading={this.state.isLoading}>
                    <div className="search-main">
                        {
                            searchHistory.length > 0 &&
                            <div className="search-land">
                                <div className='search-history'>
                                    <span>最近搜索</span>
                                    <i className="iconfont iconiconfront-56" onClick={this.clearHistory}/>
                                </div>
                                <div className="search-tag">
                                    {

                                        searchHistory.map((v, i) => {
                                            return (
                                                <Link
                                                    key={i}
                                                    to={`/search-result?word=${encodeURIComponent(v)}`}
                                                >
                                                    <Tag name={"tagLately"}>{v}</Tag>
                                                </Link>
                                            )
                                        })
                                    }
                                </div>
                            </div>
                        }
                        <div className="search-land search-hot">
                            <label className={'search-history'}>
                                <span>热门搜索</span>
                            </label>
                            <div className="search-tag">
                                {
                                    this.state['hot_words'].length > 0 ?
                                        this.state['hot_words'].map((v, i) => {
                                            return (
                                                <Link key={i}
                                                      to={`/search-result?word=${encodeURIComponent(v)}`}
                                                      onClick={this.storeHistory.bind(this, v)}
                                                >
                                                    <Tag name={"tagHot"}>{v}</Tag>
                                                </Link>
                                            )
                                        })
                                        : <div style={{textAlign: 'center', padding: '20px'}}>暂无热门</div>
                                }
                                
                            </div>
                        </div>
                    </div>
                </Loading>

            </div>
        )
    }

}

export default Search;