import React, { Component } from 'react';
import './index.scss';
import { HeaderBar, VList } from '../../common'
import { http, dateCountDown } from "@/utils";
import { Link } from 'react-router-dom'
import { Toast } from 'antd-mobile'
import { connect } from "react-redux"
import Loading from '@/common/Loading'

class Purchased extends Component {
  constructor(props) {
    super(props)
    this.state = {
      data: [],
      isLoading: true
    }
  }

  componentDidMount() {
    this.getList()
  }

  // 获取订单
  getList = () => {
    http.get(`${API.home}/m/my/courses`,).then((res) => {
      if (res.data.code === 200) {
        this.setState({
          data: res.data.data,
          isLoading: false
        })
      } else {
        Toast.info(res.data.msg, 2);
      }
    })
  }

  toCourseDetail = (id) => {
    const {dispatch, history} = this.props;
    // dispatch(getCourses(id, () => {
    history.push(`/detail?id=${id}`)
    // }));
  }
  render() {
    const {user} = this.props
    const uid = user && user.data && user.data.uid
    return (
      <div className='purchased-box'>
        <HeaderBar arrow={true} title='已购课程' cart={false} toHref='/my'/>
        <Loading isLoading={this.state.isLoading}>
          {
            this.state.data && this.state.data.length > 0 ?
              <div className="purchased-body">
                <div className='tip'>加群请备注您的学号：{uid}</div>
                {
                  this.state.data.map((item, index) => {
                    const Info = (
                      <div className="info">
                        <p className='title' onClick={() => this.toCourseDetail(item.course_id)}>
                          {item.course_title}
                        </p>
                        <p className='contact text-overflow-2'>{item.simpledescription}</p>

                        {
                          item.is_aist &&
                          <div className='des'>助教微信：{item.assist_weixin}</div>
                        }
                        {
                          !item.is_aist && item.contact_type == 1 && item.course_qq &&
                          <div className='des'>QQ群：{item.course_qq}</div>
                        }
                        {
                          !item.is_aist && item.contact_type == 2 && item.course_qq &&
                          <div className='des'>班主任微信：{item.course_qq}</div>
                        }
                      </div>
                    )
                    const status = (
                      item.is_aist && <span className='status'>返现</span>
                    )
                    const courseExpire = (
                      item.course_expire && item.course_expire != '' &&
                      <span className='course-expire'>{item.course_expire}</span>
                    )
                    return (
                      <VList
                        key={index}
                        img={item.image_name}
                        id={item.course_id}
                        info={Info}
                        status={status}
                        courseExpire={courseExpire}
                        toDetail={this.toCourseDetail}
                      />
                    )
                  })
                }
              </div>
              : <div className="cart-tip">
                <p className='cart-mess'>您还没有课程哦，快去逛逛吧~</p>
                <Link to='/classify'>去逛逛</Link>
              </div>
          }
        </Loading>

      </div>
    )
  }
}

export default connect(
  state => ({user: state.user}),
  null
)(Purchased)
