import React, { Component } from 'react'
import { NavLink, Route, Switch, Redirect } from "react-router-dom"
import myCoupons from "./myCoupons"
import myPatch from './myPatch'
import { HeaderBar } from "@/common";
import './coupons.scss'


class coupons extends Component {
    render() {
        const {match, location} = this.props;
        return (
            <div className={'coupons-box'}>
                <HeaderBar title='优惠券' arrow={true}/>
                <section id='coupons'>
                    <div className='tab'>
                        <div>
                            <NavLink to={{
                                pathname: `${match.url}/my-coupon`,
                                search: location.search,
                                state: {...this.props.location.state}
                            }}
                                     replace
                                     activeClassName='tab-active'
                            >我的优惠券</NavLink>
                        </div>
                        <div>
                            <NavLink to={{
                                pathname: `${match.url}/my-patch`,
                                search: location.search,
                                state: {...this.props.location.state}
                            }}
                                     replace
                                     activeClassName='tab-active'
                            >碎片合成</NavLink>
                        </div>
                    </div>
                    <div className="btm-border"></div>

                    <div className="coupons-container">
                        <Switch>
                            <Redirect exact from='/coupons' to={{
                                pathname: 'coupons/my-coupon', search: location.search, state: {
                                    from: this.props.location.state && this.props.location.state.from
                                }
                            }}/>
                            <Route path={`${this.props.match.path}/my-coupon`} component={myCoupons}/>
                            <Route path={`${this.props.match.path}/my-patch`} component={myPatch}/>
                        </Switch>
                    </div>
                </section>
            </div>
        )
    }

}

export default coupons;
