import React, { Component } from 'react';
import { http } from '@/utils';
import './index.scss';

class SplitSuccess extends Component {

  computedBg = (val) => {
    return val? {
      backgroundImage: `url(${val})`
    } : {};
  }

  continueSplitTreasure = () => {
    const { ids, successSplitTreasure, handleToBindPhone, handleToBindAddress } = this.props;
    const params = ids[0];
    http.post(`${API.home}/sys/split_treasure`, params).then(res => {
      const { code, data } = res.data;
      if(code === 200) {
        successSplitTreasure(data);
        if(data.bind_phone) {
          setTimeout(() => {
            handleToBindPhone(data.id);
          }, 500);
        }else if(data.bind_address) {
          setTimeout(() => {
            handleToBindAddress(data.id, data.prize_name);
          }, 500);
        }
      }else if(code === 12000) {
        // 请先绑定手机号再拆宝箱
        handleToBindPhone();
      }else if(code === 12001) {
        // 请先填写收货地址再拆宝箱
        handleToBindAddress();
      }
    });
  }

  render() {
    const { 
      ids,
      data: {
        member = [],
        prize_img,
        prize_name,
      },
      handleToInvite,
      children,
    } = this.props;
    return (
      <div data-skip="split">
        <h2 className="split-success__title">恭喜你获得</h2>
        <div className="split-success__image">
          <img src={prize_img} alt=""/>
        </div>
        <p className="split-success__prize">{prize_name}</p>

        {children}

        <div className="split-success__member">
          {
            member.map((item, index) => (
              <div className="member-item" key={index}>
                <span className="member-item__avatar" style={this.computedBg(item.avatar)}>
                  {
                    item.is_captain && <i className="member-item__captain">队长</i>
                  }
                </span>
                {
                  item.prize
                  ? <span className="member-item__prize">{item.prize}</span>
                  : <span className="member-item__prize">尚未开宝箱</span>
                }
              </div>
            ))
          }
        </div>
        {
          ids.length > 0
          ? <button className="split-success__jump" onClick={this.continueSplitTreasure}>继续开宝箱</button>
          : <button className="split-success__jump" onClick={handleToInvite}>继续组队开宝箱</button>
        }
      </div>
    );
  }
}

export default SplitSuccess;