import React, { Component } from 'react'
import {connect} from "react-redux";
import { http, getParam } from '@/utils';
import cookie from 'js-cookie'
import './index.scss';
import {Toast} from "antd-mobile";
import jsCookie from 'js-cookie';

class Activity extends Component {
  constructor(props) {
    super(props);
    this.state = {
      'butText': '立即领取'
    }
  }

  componentWillMount() {
    jsCookie.set('blessing_invite_uid', getParam('shareuid'), {domain: '.julyedu.com', expires: 30});
    jsCookie.set('blessing_invite_code', getParam('inviteCode'), {domain: '.julyedu.com', expires: 30});
    if(cookie.get('uid')) {
      this.setState(()=>({
        butText: '已领取，去使用'
      }));
    }
  }

  getGift = () => {
    if(this.props.user.hasError) {
      this.props.history.push('/passport', {from: this.props.location.pathname});
    } else {
      this.props.history.push('/blessingPreheat');
    }
  }

  render() {
    const {butText} = this.state;
    return (
      <div className="activity__con">
        <div className='banner__con'></div>
        <div className='content__con'>
          <div className="button__get" onClick={this.getGift}>{butText}</div>
        </div>
      </div>
    )
  }
}

export default connect(
  state => ({user: state.user}),
  null
)(Activity);
