import React, { Component } from 'react';
import { Flex, WingBlank, WhiteSpace, List, Radio, Toast } from 'antd-mobile';
import { http, getParam, is_weixin, browser } from '@/utils';
import { OrderItem, HeaderBar } from '@/common/index';
import { Link } from 'react-router-dom';
import './PayOrder.scss';
import { VList } from '@/common';


const Item = List.Item;
const Brief = Item.Brief;
const RadioItem = Radio.RadioItem;

let mockData = []
if (browser.isWeixin) {
    mockData = [
        {value: 1, label: '微信支付', icon: 'iconweixinzhifu'}
    ];
} else {
    mockData = [
        {value: 1, label: '微信支付', icon: 'iconweixinzhifu'},
        {value: 0, label: '支付宝', icon: 'iconalipay'},
        // { value: 2, label: '花呗分期', icon: 'iconhuabei' },
    ];
}


export default class PayOrder extends Component {
    constructor(props) {
        super(props);
        this.state = {
            pay_amount: 0,
            payType: 1,
            stageNumber: 0,
            checkPeriod: false,
            singleMoney: 0,
            periodNumber: 0,
            orderId: getParam('oid'),
            huabei: false,
            fenqiList: [
                {value: 'zhifubao', qishu: '3', lilv: '2.30%', everyMoney: 300, feiyong: 2.3},
                {value: 'weixin', qishu: '6', lilv: '4.50%', everyMoney: 150, feiyong: 4.5},
                {value: 'huabei', qishu: '9', lilv: '7.50%', everyMoney: 100, feiyong: 7.5},
            ],
            categoryList: [],
        }
    }

    // 支付成功后，判断并重定向
    redirectAfterPay = () => {
        // status:0成功，1失败
        const status = getParam('status');
        const type = getParam('type');
        const oid = getParam('oid');
        const {history} = this.props;
        if (status || type) {
            if (parseInt(status, 10) === 0) {
                // type订单类型 0普通订单 1团购 2小团 3砍价 4单集购买 5定金课定金 6定金课尾款
                if (parseInt(type, 10) === 2) {
                    history.push(`/togroup?id=${oid}`);
                }else if(parseInt(type, 10) === 4) {
                courseId && window.localStorage.setItem('payCourse', courseId);
                    const courseId = window.localStorage.getItem('payCourse')
                    courseId && history.push(`/detail?id=${courseId}`,{oid});
                } else {
                    history.push('/purchased');
                }
            } else {
                Toast.info('支付异常', 2);
            }
        }
    }

    onChange = (value) => {
        this.setState({
            payType: value,
            checkPeriod: false,
        });
        if (value === 2) {
            this.setState({
                huabei: true,
            });
        }
    };
    checkStaging = (item) => {
        // console.log(item);
        this.setState({
            huabei: false,
            stageNumber: item.value,
            singleMoney: item.everyTotal,
            periodNumber: item.stage,
            checkPeriod: true,
        });
    }
    print = (...e) => {
        console.log(e);
    };
    // 确定购买
    pay = () => {
        const {payType, orderId} = this.state;
        if (payType === 0) {
            this.alipayPay(orderId);
        } else if (payType === 1) {
            this.weixinPay(orderId)
        }
        // else { // 花呗分期暂时不做
        //     this.huabeiPay(orderId)
        // }
    }
    // 微信支付
    weixinPay = (orderId) => {
        // 微信内部-支付
        if (is_weixin()) {
            window.location.href = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=wx23dac6775ac82877&redirect_uri=" + encodeURIComponent(window.location.href + "&aa=bb").toLowerCase() + "&response_type=code&scope=snsapi_userinfo&state=STATE#wechat_redirect";
            // if(window.location.href.indexOf('aa=bb') === -1){
            //     localStorage.setItem('a', '第一次');
            //     window.location.href = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=wx23dac6775ac82877&redirect_uri=" + encodeURIComponent(window.location.href + "&aa=bb").toLowerCase() + "&response_type=code&scope=snsapi_userinfo&state=STATE#wechat_redirect";
            // }
            // if(window.location.href.indexOf('aa=bb') > 0) {
            //     localStorage.setItem('a', '多次');
            //     let newHref = window.location.href.slice(0, window.location.href.indexOf('aa=bb')-1);
            //     window.location.href = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=wx23dac6775ac82877&redirect_uri=" + encodeURIComponent(newHref + "&aa=bb").toLowerCase() + "&response_type=code&scope=snsapi_userinfo&state=STATE#wechat_redirect";
            // }
        } else {
            // 微信外部-支付
            http.get(`${API['base-api']}/pay/wxpay/wap_charge/oid/${orderId}`).then((res) => {
                // console.log(res);
                if (res.data.errno === 0) {
                    window.location.href = res.data.data.url + "&redirect_url=" + encodeURIComponent(window.location.href + "&weixinpay=1").toLowerCase();
                } else {
                    Toast.info(res.data.msg, 2)
                }
            })
        }
    }
    // 微信内部支付
    isweixinPay = () => {
        let _this = this;
        let weixin_code = getParam('code');
        if (weixin_code) {
            if (getParam('oid') === undefined) {
                return
            } else {
                http.get(`${API['base-api']}/pay/wxpay/pub_charge/oid/${getParam('oid')}/code/${weixin_code}`).then((res) => {
                    if (res.data.errno === 0) {
                        let data = res.data.data;

                        function onBridgeReady() {
                            WeixinJSBridge.invoke(
                                'getBrandWCPayRequest', {
                                    appId: data.appId,                //公众号名称，由商户传入
                                    timeStamp: data.timeStamp,        //时间戳，自1970年以来的秒数
                                    nonceStr: data.nonceStr,          //随机串
                                    package: data.package,
                                    signType: data.signType,          //微信签名方式：
                                    paySign: data.paySign             //微信签名
                                },
                                function (res) {
                                    if (res.err_msg == "get_brand_wcpay_request:ok") {
                                        Toast.info('支付成功', 2);
                                        _this.intervalPayStatus = setInterval(function () {
                                            http.get(`${API['base-api']}/m/orderState/oid/${getParam('oid')}`).then(res => {
                                                if (res.data.errno === 401) {
                                                    clearInterval(_this.intervalPayStatus);
                                                    _this.intervalPayStatus = null;
                                                    // 获取课程类型
                                                    http.get(`${API['base-api']}/m/app_order/detail/${getParam('oid')}`).then(res => {
                                                        if (Number(res.data.data.course_type) === 2) {
                                                            _this.props.history.replace(`/togroup?id=${getParam('oid')}`);
                                                        } else {
                                                            // 跳转到已购课程  /purchased 不需要传递任何参数
                                                            _this.props.history.replace(`/purchased`);
                                                        }
                                                    });
                                                }
                                            })
                                        }, 1000)
                                    } else {
                                        alert('支付失败')
                                    }
                                }
                            )
                        }

                        if (typeof WeixinJSBridge == "undefined") {
                            if (document.addEventListener) {
                                document.addEventListener('WeixinJSBridgeReady', onBridgeReady, false)
                            } else if (document.attachEvent) {
                                document.attachEvent('WeixinJSBridgeReady', onBridgeReady);
                                document.attachEvent('onWeixinJSBridgeReady', onBridgeReady)
                            }
                        } else {
                            onBridgeReady();
                        }
                    } else {
                        Toast.info(res.data.msg, 2)
                    }
                })
            }
        }
    }
    // 支付完成之后获取状态
    payCallback = () => {
        const _this = this;
        // 支付回调
        // 定时器轮训获取订单状态
        _this.intervalPayStatus = setInterval(function () {
            http.get(`${API['base-api']}/m/orderState/oid/${getParam('oid')}`).then(res => {
                if (res.data.errno === 401) {
                    clearInterval(_this.intervalPayStatus);
                    _this.intervalPayStatus = null;
                    // 获取课程类型
                    http.get(`${API['base-api']}/m/app_order/detail/${getParam('oid')}`).then(res => {
                        if (Number(res.data.data.course_type) === 2) {
                            _this.props.history.replace(`/togroup?id=${getParam('oid')}`);
                        } else {
                            // 跳转到已购课程  /purchased 不需要传递任何参数
                            _this.props.history.replace(`/purchased`);
                        }

                    });
                }
            })
        }, 1000)
    }

    onBridgeReady1 = (data) => {
        let _this = this;
        data = data || _this.BridgeData;

        WeixinJSBridge.invoke(
            'getBrandWCPayRequest', {
                "appId": "wx23dac6775ac82877",                //公众号名称，由商户传入
                "timeStamp": data.timeStamp,        //时间戳，自1970年以来的秒数
                "nonceStr": data.nonceStr,          //随机串
                "package": data.package,
                "signType": data.signType,          //微信签名方式：
                "paySign": data.paySign             //微信签名
            },
            function (res) {
                if (res.err_msg == "get_brand_wcpay_request:ok") {
                    Toast.info('支付成功', 2);
                    _this.payCallback();
                } else {
                    alert('支付失败')
                }
            }
        )
    }
    // 支付宝支付
    alipayPay = (orderId) => {
        http.get(`${API['base-api']}/pay/alipay/wap_charge_new/oid/${orderId}`).then((res) => {
            if (res.data.errno === 0) {
                this.payCallback();
                window.location = res.data.data.url;
            } else {
                Toast.info(res.data.msg, 2)
            }
        })
    }
    // 花呗分期 暂时不做
    huabeiPay = (orderId) => {
        const {singleMoney, periodNumber} = this.state;

        // console.log('花呗分期支付');
        http.get(`/pay/alipay/wap_charge/oid/${orderId}/plat/{plat} /hb_num/${periodNumber}`).then(res => {
            // console.log(res);
            if (res.data.errno === 0) {
                window.location = res.data.data.url;
            } else {
                Toast.info(res.data.msg, 2)
            }
        });
    }

    componentDidMount() {
        this.redirectAfterPay()
        let data = {}
        if(this.props.location.state && this.props.location.state.group){
            data = {
                order_id: this.state.orderId,
                type: 2
            }
        } else {
            data = {
                order_id: this.state.orderId,
            }
        }
        http.post(`${API['base-api']}/m/order/detail`,data).then((res) => {
            if (res.data.errno !== 200) {
                Toast.info(res.data.msg, 2);
                return;
            }
            const {course, pay_amount} = res.data.data;
            const fenqiList = [];
            [1, 2, 3].map((item) => {
                let obj = {};
                obj.value = item;
                if (item === 1) {
                    obj.stage = 3; //期数
                    obj.moneyRate = '2.30%'; // 分期费率展示
                    obj.rate = 0.023; // 分期费率计算
                    obj.periodic = (pay_amount / 3).toFixed(2); // 每期本金
                } else if (item === 2) {
                    obj.stage = 6; //期数
                    obj.moneyRate = '4.50%'; // 分期费率展示
                    obj.rate = 0.045; // 分期费率计算
                    obj.periodic = (pay_amount / 6).toFixed(2); // 每期本金
                } else {
                    obj.stage = 12; //期数
                    obj.moneyRate = '7.50%'; // 分期费率展示
                    obj.rate = 0.075; // 分期费率计算
                    obj.periodic = (pay_amount / 9).toFixed(2); // 每期本金
                }
                obj.serviceFee = ((pay_amount * obj.rate) / obj.stage).toFixed(2); // 每期的手续费 = 总金额 * 费率 / 期数
                obj.everyTotal = (parseFloat(obj.periodic) + parseFloat(obj.serviceFee)).toFixed(2);// 每期总费用 = 每期本金 + 每期手续费
                fenqiList.push(obj);
            });
            // console.log(fenqiList);
            // { value: 'zhifubao',  qishu: '3', lilv: '2.30%', everyMoney: 300, feiyong: 2.3 },
            // { value: 'weixin',  qishu: '6', lilv: '4.50%', everyMoney: 150, feiyong: 4.5 },
            // { value: 'huabei',  qishu: '9', lilv: '7.50%', everyMoney: 100, feiyong: 7.5 },
            this.setState({
                pay_amount,
                categoryList: course,
                fenqiList,
            });
        });
        if (getParam('is_class') === 1 || getParam('weixinpay')) {
            this.payCallback()
        }
        if (is_weixin()) {
            this.setState({
                payType: 1
            })
            this.isweixinPay()
        }
    }

    render() {
        const {orderId, pay_amount, payType, checkPeriod, singleMoney, periodNumber, huabei, fenqiList, categoryList, stageNumber} = this.state;
        return (
            <div className='pay-order'>
                <HeaderBar title='确认支付' arrow={true}></HeaderBar>
                <WhiteSpace size='sm'></WhiteSpace>
                <div className='order-number'>
                    <WingBlank>
                        <Flex justify='between' align='center' style={{height: '44px'}}>
                            <span>订单号</span>
                            <span className='number'>{orderId}</span>
                        </Flex>
                    </WingBlank>
                </div>
                <WhiteSpace size='md'></WhiteSpace>
                {
                    categoryList.map((item, index) => {
                        const Info = (
                            <div className="order-info">
                                <p className='order-title text-overflow-one'>
                                    <Link to={`/detail?id=${item.course_id}`}>{item.course_title}</Link>
                                </p>
                                <p className='order-content text-overflow-2'>{item.simpledescription}</p>
                                <p className='order-des'>
                                    <span className='order-newprice'>¥{item.price1}</span>
                                    <span className='order-price'>¥{item.price0}</span>
                                </p>
                            </div>
                        )
                        return (
                            <VList handleClick={this.print} key={index} img={item.image_name}
                                   id={item.course_id}
                                   info={Info}></VList>
                        )
                    })
                }
                <WhiteSpace size='md'></WhiteSpace>
                <div className='order-number'>
                    <WingBlank>
                        <Flex justify='between' align='center' style={{height: '44px'}}>
                            <span>支付金额</span>
                            <span className='money'>{`￥${pay_amount}`}</span>
                        </Flex>
                    </WingBlank>
                </div>

                <WhiteSpace size='md'></WhiteSpace>
                <List renderHeader={() => '支付方式'} className='pay-type-list'>
                    {mockData.map(i => (
                        <RadioItem
                            thumb={<i className={`iconfont ${i.icon} ${payType === i.value ? 'checked' : ''}`}></i>}
                            key={i.value}
                            checked={payType === i.value}
                            onChange={() => this.onChange(i.value)}>
                            {/* {i.label} */}
                            {
                                i.value === 2 ? (
                                    <Flex direction='column' align='start' style={{width: '100%', marginTop: '6px'}}>
                                        <Flex direction='row' justify='between'
                                              style={{width: '100%', paddingRight: '30px'}}>
                                            <span style={{color: '#555555', fontSize: '14px'}}>{i.label}</span>
                                            {
                                                checkPeriod ? (
                                                    <span style={{
                                                        color: '#333333',
                                                        fontSize: '12px'
                                                    }}>{`${singleMoney}元 × ${periodNumber}期`}</span>
                                                ) : null
                                            }
                                        </Flex>
                                        <Flex justify='start'>
                                            <span style={{color: '#999999', fontSize: '12px'}}>支付上限受限于您的花呗额度</span>
                                        </Flex>
                                    </Flex>
                                ) : (i.label)
                            }
                        </RadioItem>
                    ))}
                </List>
                <div className='pay-tip'>请在15分钟内完成支付，否则届时系统将关闭该订单。</div>

                <div className='pay-button' onClick={this.pay}>确认支付</div>

                {
                    huabei ? (
                        <div className='check-staging'>
                            <div className='container'>
                                <p className='check-title'>请选择分期</p>
                                {fenqiList.map(i => (
                                    <RadioItem
                                        key={i.value}
                                        checked={stageNumber === i.value}
                                        onChange={() => this.checkStaging(i)}>
                                        {`${i.everyTotal}元 × ${i.stage}期`}
                                        <List.Item.Brief>{`手续费${i.serviceFee}元/期，费率${i.moneyRate}`}</List.Item.Brief>
                                    </RadioItem>
                                ))}
                            </div>
                        </div>
                    ) : null
                }
            </div>
        )
    }
}
