import React, {Component} from 'react';
import {InputItem, List} from "antd-mobile";
import './bargain-info.scss'
import {validateTel} from "@/utils";
import {Toast} from 'antd-mobile'
import { http, getParam } from "@/utils";
import {Link} from "react-router-dom";
import classnames from 'classnames';


class BargainInfo extends Component {

    state = {
        mobile: '',
        code: '',
        num: '86',
        isBargain: true,
        isFocus: false,
        bindInfo: {},
        isTip: false,
        seconds: 60,
        isTimer: false, // 是否开始倒计时
    }

    handleChange = e => {

        let {name, value} = e.target

        this.setState({
            [name]: value
        })
    }

    // 获取短信验证码
    sendCode = () => {
        const { country } = this.props;
        let { mobile, isTimer, seconds } = this.state;
        if(!isTimer) {
            if(!/^\d+$/.test(mobile)){
                Toast.info('请输入正确的手机号');
                return;
            }

            // 获取验证码
            http.post(
                `${API['passport-api']}/m/personal/bindPhoneSendCode`,
                {
                    area_code: `00${country}`,
                    phone_num: mobile
                }
            ).then(res => {
                const { errno, msg } = res.data;
                if(errno === 200) {
                    Toast.info('验证码发送成功', 2, null, false);
                    
                    // 倒计时
                    this.timer = window.setInterval(() => {
                        console.log(seconds);
                        if (seconds <= 0) {
                            window.clearInterval(this.timer);
                            this.setState({
                                isTimer: false,
                                seconds: 60
                            });
                        }else {
                            this.setState({
                                isTimer: true,
                                seconds: --seconds
                            });
                        }
                    }, 1000);
                }else {
                    Toast.info(msg);
                }
            });
        }

        // http.post(`${API['base-api']}/sys/bind_send_sms`, {
        //     phone_num: this.state.mobile
        // }).then(res => {
        //     if (res.data.code == 200) {
        //         Toast.info('验证码发送成功', 2, null, false)
        //     } else if (res.data.errno === 410) {
        //         Toast.info('该手机号已注册，请使用该手机号登录，发起砍价。', 3, null, false)
        //         this.setState({
        //             isBargain: false
        //         })
        //     } else {
        //         Toast.info(res.data.msg)
        //     }
        // })
    }

    // 绑定手机号
    handleClick = (isValid = 1) => {
        const { country, iWantBargain } = this.props;
        const { code, mobile } = this.state;
        if (!mobile) {
            Toast.info('请填手机号码');
            return;
        }
        if (!code) {
            Toast.info('请填写验证码');
            return;
        }

        // is_valid	是否验证 1:验证（默认）,0不验证
        http.post(
            `${API['passport-api']}/m/personal/bindPhone`,
            {
              area_code: `00${country}`,
              phone_num: mobile,
              code: code,
              type: 1,
              is_valid: isValid
            }
        ).then(res => {
            const { errno, data, msg } = res.data;
            if(errno === 200) {
                if(isValid) {
                    if(data.tip_info) {
                      this.setState({
                        isTip: true,
                        bindInfo: data.tip_info
                      })
                    }else {
                      iWantBargain();
                    }
                }else {
                    iWantBargain();
                }
            }else {
                Toast.info(msg);
            }
        });


        // http.post(`${API.home}/m/user/bindMobile`, {
        //     ...this.state
        // }).then(res => {
        //     if (res.data.code == 200) {
        //         Toast.info('绑定手机号成功', 2, null, false)
        //         this.props.iWantBargain()
        //     } else {
        //         Toast.info(res.data.msg)
        //     }
        // })

    }


    render() {
        const { country, toClose } = this.props;
        const { mobile, code, isBargain, isFocus, bindInfo, isTip, isTimer, seconds } = this.state;
        const bool = /^\d+$/.test(mobile);
        return (
            <>
                {/* 该手机号已绑定其他帐号 */}
                {
                    isTip &&
                    <div className="popup-bind popup-bind--bargain">
                        <div className="popup-bind__content">
                        <h4 className="popup-bind__title">绑定确认</h4>
                        <p className="popup-bind__desc">该手机号已绑定到以下账号，继续绑定将解除以下绑定状态</p>
                        <ul className="popup-bind__list">
                            {
                            bindInfo['email'] &&
                            <li className="popup-bind__account">

                                {/* 邮箱 */}
                                <i className="iconfont iconduanxin"></i>
                                <p className="popup-bind__account--name">{bindInfo['email']}</p>
                            </li>
                            }
                            {
                            bindInfo['wechat_nickname'] &&
                            <li className="popup-bind__account">

                                {/* wechat */}
                                <i className="icon-wachat"></i>
                                <p className="popup-bind__account--name">{bindInfo['wechat_nickname']}</p>
                            </li>
                            }
                            {
                            bindInfo['qq_nickname'] &&
                            <li className="popup-bind__account">

                            {/* qq */}
                            <i className="icon-qq"></i>
                            <p className="popup-bind__account--name">{bindInfo['qq_nickname']}</p>
                            </li>
                            }
                            {
                            bindInfo['sina_nickname'] &&
                            <li className="popup-bind__account">

                                {/* 微博 */}
                                <i className="icon-sina"></i>
                                <p className="popup-bind__account--name">{bindInfo['sina_nickname']}</p>
                            </li>
                            }
                        </ul>
                        <div className="popup-bind__button">
                            <button
                            className="popup-bind__button--cancle"
                            onClick={toClose}>取消</button>
                            <button
                            className="popup-bind__button--confirm"
                            onClick={() => this.handleClick(0)}>继续绑定</button>
                        </div>
                        </div>
                    </div>
                }
                {
                    !isTip &&
                    <div className="bargain-phone-popup">
                        <h2 className="bargain-phone-popup__title">绑定手机，先砍一刀</h2>
                        <div 
                            className={classnames(
                                "bargain-phone-popup__item",
                                {
                                    'active': isFocus
                                }
                            )}
                        >
                            <Link
                                className="bargain-phone-popup__button--num"
                                to={`/country?id=${getParam('id')}&from=bargain`}
                                >
                                +{country}
                                <i className="iconfont iconiconfront-69"></i>
                            </Link>
                            <input 
                                className="bargain-phone-popup__ipt"
                                type="tel" 
                                onChange={this.handleChange}
                                onFocus={() => {
                                    this.setState({
                                        isFocus: true
                                    });
                                }} 
                                onBlur={() => {
                                    this.setState({
                                        isFocus: false
                                    });
                                }}
                                name='mobile' 
                                placeholder='手机号' 
                                maxLength={11}
                            />
                        </div>
                        <div className="bargain-phone-popup__item">
                            <input 
                                type="tel" 
                                id='code' 
                                onChange={this.handleChange} 
                                name='code' 
                                placeholder='验证码'
                                maxLength={6}
                            />
                            <button 
                                type="button"
                                className={classnames(
                                    'bargain-phone-popup__button--send',
                                    {
                                        'active': bool
                                    }
                                )}
                                onClick={this.sendCode}
                            >
                                {isTimer? `重新发送${seconds}s` : '发送验证码'}
                            </button>
                        </div>
                        {
                            isBargain
                            ? (
                                <button 
                                    type="button"
                                    onClick={() => this.handleClick()}
                                    className={classnames(
                                        'bargain-phone-popup__button--bargain', 
                                        {
                                            'active': bool && code
                                        }
                                    )}
                                >先砍一刀</button>
                            )
                            : (
                                <Link 
                                    className='bargain-phone-popup__button--bargain active'
                                    to={`/passport/login`}
                                >去登录</Link>
                            )
                        }
                    </div>
                }
            </>
        );
    }
}

export default BargainInfo;