import React, { Component } from 'react'
import { connect } from 'react-redux'
import { http } from "@/utils"
import { Popup } from '@/common'
import AddressPopup from './../blessingPreheat/addressPopup/index'
import './index.scss'

@connect(({user}) => (
  {
    uid: user.data.uid || ''
  }
))
class BlessingRank extends Component {
  popupInstance = null
  constructor(props) {
    super(props)
    this.state = {
      rankList: [],
      rules: [
        '1、排行榜名次以2019年11月13日24点七月在线公布的排行榜为准，榜单确认后，得奖小伙伴请及时填写邮寄信息，7个自然日内不填写，视为主动放弃奖品；',
        '2、福气值只在本活动期间享受抽奖、提高中奖概率、购课优化、增加AI水平测试等福利；',
        '3、如有发现恶意刷榜，刷虚假数据等行为将取消其领奖资格；',
        '4、本活动解释权归北京七月在线科技有限公司所有。',
      ],
    }
  }

  componentDidMount() {
    this.fetchRankData()
  }

  fetchRankData = () => {
    http.get(`${API.home}/sys/blessing/ranking`).then(res => {
      const {code, data} = res.data
      if (code === 200) {
        this.setState({
          rankList: data,
        })
      }
    })
  }

  handleToSwitch = (bool) => {
    const {history, uid} = this.props
    if (bool && !uid) {
      history.push('/passport')
    } else {
      if (bool && !this.popupInstance) {
        this.popupInstance = Popup({
          title: '收货信息',
          content: <AddressPopup handleToHide={() => this.handleToSwitch(false)}/>
        })
      } else {
        this.popupInstance.close()
        this.popupInstance = null
      }
    }
  }

  formatString = (str, len) => {
    return str.length > len ? `${str.substr(0, len)}...` : str
  }

  render() {
    const {rankList, rules} = this.state
    return (
      <>
        <div className="rank__banner"></div>
        <div className="rank__body">
          <button className="rank__address" onClick={() => this.handleToSwitch(true)}>填写收货地址></button>
          <div className="rank__table">
            <dl className="rank__table-header">
              <dd className="rank__table-column">排名</dd>
              <dd className="rank__table-column">用户</dd>
              <dd className="rank__table-column">成绩</dd>
              <dd className="rank__table-column">奖品</dd>
            </dl>
            {
              rankList.map((item, index) => {
                return (
                  <dl className="rank__table-body" key={index}>
                    <dd className="rank__table-column">
                      {
                        index < 3
                          ? (
                            <i className="rank__table-num" data-num={index + 1}></i>
                          )
                          : index + 1
                      }
                    </dd>
                    <dd className="rank__table-column">
                      <div className="rank__table-user">
                        <i className="rank__table-portrait" style={{backgroundImage: `url(${item.head_image})`}}></i>
                        <span>{this.formatString(item.user_name, 5)}</span>
                      </div>
                    </dd>
                    <dd className="rank__table-column">{item.blessing_value}</dd>
                    <dd className="rank__table-column">{this.formatString(item.prize_name, 7)}</dd>
                  </dl>
                )
              })
            }

          </div>
          <div className="rank__rule">
            <h2 className="rank__rule-title">活动规则</h2>
            {
              rules.map((item, index) => (
                <p className="rank__rule-desc" key={index}>{item}</p>
              ))
            }
          </div>
        </div>
      </>
    )
  }
}

export default BlessingRank
