import React, { Component } from 'react'
import './index.scss'
import { http, getParam } from '@/utils';

export default class RecordPopup extends Component {
  constructor(props) {
    super(props);
    this.state = {
      recordList: [],
    }
  }

  componentDidMount () {
    http.get(`${API.home}/sys/ai_test/get_user_testinfo`).then(res => {
        let {code, data: {user_test_record}} = res.data;
        if(code === 200) {
          this.setState({
            recordList: user_test_record
          })
        }
    });
  }

  handleToTestRecord = (e, id) => {
    e.preventDefault();
    const { history } = this.props;
    if(getParam('version')) {
      location.href = `${API.m}/levelTest/report?id=${id}&version=${getParam('version')}`;
    } else {
      location.href = `${API.m}/levelTest/report?id=${id}&version=${getParam('version')}`;
    }
  }


  render() {
    let {recordList} = this.state;
    const { handleToHide } = this.props;
    return (
      <div className='record__mark'>
      <div className="gift__record">
        <div className="close__button" onClick={handleToHide}>
          <i className="icon iconfont iconiconfront-77"></i>
        </div>
        <p className="mark__title">测试记录</p>
        <p className="mark__tip">多次测试保留最高分，可查看最近一次答题记录</p>
        <div>
          <div className="table__head">
            <span className="tr">测试时间</span>
            <span className="tr">分数</span>
            <span className="tr">操作</span>
          </div>
          <div className="table__body">
          {
            recordList.length>0?
            recordList.map((item, index) => {
              return (<div className="tr__container" key={index}>
              <span className="tr">{item.submit_time}</span>
              <span className="tr">{item.score}</span>
              <span className="tr">
                {
                  index === 0 ? (
                    <a onClick={(e) => this.handleToTestRecord(e, item.id)}>测试记录</a>
                  ) : (null)
                }
              </span>
            </div>
              )
            }):
                <div className={'notdata'}>暂无测试记录</div>
          }
          </div>
        </div>
      </div>

      </div>
    )
  }
}
