import React, { Component } from 'react';
import './index.scss';
import ListHeader from './../blessingPreheat/listHeader/index'
import { http, getParam } from '@/utils';
import { Toast } from 'antd-mobile';
import AddressPopup from './../blessingPreheat/addressPopup/index'
import { Popup } from '@/common'
import { connect } from 'react-redux'
import jsCookie from 'js-cookie'
@connect(({user}) => (
  {
    uid: user.data.uid || ''
  }
))
class BlessingGetPrize extends Component {
  popupInstance = null
  constructor(props) {
    super(props);
    this.state = {
      date: '',
      next_date: '',
      name: '',
      is_winning: "", //是否中奖
      is_virtual: 1, // 实物奖品 虚拟奖品
      prize_data: [],
      address: false,
    }
  }

  componentDidMount () {
    const _this = this;
    setTimeout(function(){
      const {history, uid} = _this.props;
      if(!uid) {
        history.push('/passport');
      }else{
        http.get(`${API.home}/sys/lottery_result?id=${getParam('id')}`).then(res => {
          const {code, msg, data} = res.data;
          if(code === 200) {
            _this.setState({
              ...data.info,
              prize_data: data.prize_data.slice(0, 6),
            })
          } else {
            Toast.info(msg);
          }
        });
      }
    }, 300);
  }

  showAddress = (bool) => {
    const {history, uid} = this.props;
    const {name} = this.state;
    if (bool && !uid) {
      history.push('/passport')
    } else {
      if (bool && !this.popupInstance) {
        this.popupInstance = Popup({
          title: '恭喜您',
          content: <AddressPopup tip='填写您的联系方式' prize={name} handleToHide={() => this.showAddress(false)}/>
        })
      } else {
        this.popupInstance.close()
        this.popupInstance = null
      }
    }
  }

  render() {
    const {date, next_date, name, is_winning, is_virtual, prize_data, address} = this.state;
    return (
      <div className="blessing_get_prize">
        <div className='is__get_prize'>
          <div className="get_piriz__info">
            <div className='result'>{date}中奖结果</div>
            {
              is_winning === 0 && (
                <div className='no_prize'>很遗憾，你未中奖～</div>
              )
            }
            {
              is_winning === 1 && is_virtual === 0 && (
                <div className='real__prize'>
                  <div>恭喜你，已抽中{name}奖品</div>
                  <span onClick={()=> this.showAddress(true)} className='address'>填写收货地址</span>
                </div>
              )
            }
            {
              is_winning === 1 && is_virtual === 1 && (
                <div className='virtual '>
                  <div>恭喜你抽中{name}，</div>
                  <div>奖品已存放到你的账户</div>
                </div>
              )
            }
          </div>
        </div>
        
        { 
          prize_data && prize_data.length > 0 && <>
          <div className='current_stage'>
            {next_date}
          </div>
          <ListHeader text="抽奖已开启" styles={{margin: '16px 0 18px'}}/>

          <div className='prize_list_container'>
              {
                prize_data.length > 0 && prize_data.map((item, index) => {
                  return (<div className='prize__item' key={index}>
                    <img className='prize__image' src={item.img}></img>
                    <div className='name__num'>
                      <span>{item.name}</span>
                      <span>（{`*${item.num}`}）</span>
                    </div>
                  </div>)
                })
              }
          </div>
  
          <a href='/blessingPreheat' className='join__button'>
            立即参与抽奖
          </a>
  
          <div className='prize__tip'>
            <div className='line'></div>
            <span>中奖小tips</span>
            <div className='line'></div>
          </div>
          <div className='blessing__des'>积攒的福气值越高，中奖概率越大哦</div>
          <a className='to__preheat' href='/invite'>积攒更多福气值</a>
          </>
        }
        {
          (!prize_data || prize_data.length === 0) && (
            <div className="active_over_container">
              <img src='https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/active19_1111/m/acitve__over.png' alt=''/>
              <p>七月在线双十一抽奖活动已结束， 感谢你的参与！</p>
            </div>
          )
        }
      </div>
    )
  }
}
export default BlessingGetPrize